/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle.packs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.registry.particle.packs.SimpleRuneColorPack;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;

public class SculkPack
extends SimpleRuneColorPack {
    private TextureAtlasSprite TENDRILS_SPRITE = null;

    public SculkPack() {
        this.ticks = 100;
        this.colors.add(new float[]{13.0f, 63.0f, 74.0f});
        this.colors.add(new float[]{28.0f, 133.0f, 156.0f});
    }

    @Override
    public void chargeAnimation(Level level, Player player, BlockPos blockPos) {
        for (int i = 0; i < 360; i += 72) {
            double rad = (double)i * Math.PI / 180.0;
            level.m_7106_((ParticleOptions)new VibrationParticleOption((PositionSource)new BlockPositionSource(blockPos), 20), (double)blockPos.m_123341_() + 0.5 + Math.sin(rad) * 3.0, (double)blockPos.m_123342_() + 1.5, (double)blockPos.m_123343_() + 0.5 + Math.cos(rad) * 3.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void depleteAnimation(Level level, Player player, BlockPos blockPos) {
        for (int i = 0; i < 60; i += 10) {
            level.m_7106_((ParticleOptions)new ShriekParticleOption(i), (double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 2), (double)blockPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean obeliskRenderTick(RespawnObeliskBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (this.TENDRILS_SPRITE == null) {
            this.TENDRILS_SPRITE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(RenderUtils.getThemeTextures().get("sculk_tendrils"));
        }
        RenderUtils.renderSculkTendrils(be, poseStack, this.TENDRILS_SPRITE, buffer, light);
        return false;
    }

    @Override
    public SoundEvent depleteSound() {
        return SoundEvents.f_215750_;
    }

    @Override
    public SoundEvent chargeSound() {
        return SoundEvents.f_215779_;
    }
}

